<?php
// Set the path to the tabs storage file
$tabsFile = "tabs.json";

// Handle the add tab request
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["addTab"])) {
    $tabs = json_decode(file_get_contents($tabsFile), true);
    $newTabName = $_POST["newTabName"];
    $tabs[] = $newTabName;
    // Encode the updated tabs array back to JSON
    $jsonTabs = json_encode($tabs);
    // Save the updated JSON string to the tabs file
    $success = file_put_contents($tabsFile, $jsonTabs);
    if ($success === false) {
        echo "Failed to save to tabs.json";
    }
    exit;
}

// Handle the delete tab request
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["deleteTab"])) {
    $tabs = json_decode(file_get_contents($tabsFile), true);
    $tabName = $_POST["tabName"];
    $tabIndex = array_search($tabName, $tabs);
    if ($tabIndex !== false) {
        // Remove the tab from the array
        unset($tabs[$tabIndex]);
        // Re-index the array to fix the indices
        $tabs = array_values($tabs);
        // Encode the updated tabs array back to JSON
        $jsonTabs = json_encode($tabs);
        // Save the updated JSON string to the tabs file
        $success = file_put_contents($tabsFile, $jsonTabs);
        if ($success === false) {
            echo "Failed to save to tabs.json";
        }

        // Delete the corresponding text file
        $textFile = 'text_' . $tabName . '.txt';
        if (file_exists($textFile)) {
            unlink($textFile);
        }
    }
    exit;
}

// Return the current list of tabs
if ($_SERVER["REQUEST_METHOD"] === "GET" && isset($_GET["getTabs"])) {
    echo file_get_contents($tabsFile);
    exit;
}
?>
