<?php
$tabName = $_GET['tab']; // 获取GET请求中的标签名称

// 根据标签名称来命名文本文件
$filename = 'text_' . $tabName . '.txt';

// 如果是POST请求，则保存文本内容到对应文件中
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $text = $_POST['text']; // 获取POST请求中的文本内容
    file_put_contents($filename, $text); // 将文本内容保存到对应文件中
} else {
    // 如果是GET请求，则返回对应文件中的文本内容
    if (file_exists($filename)) {
        echo file_get_contents($filename); // 输出对应文件中的文本内容
    }
}

// 删除标签时清空文件内容并在标签列表中删除该标签
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["deleteTab"])) {
    if (file_exists($filename)) {
        // 清空文件内容
        file_put_contents($filename, '');
        echo "Text file for tab '$tabName' content replaced with empty.";

        // 在标签列表中删除该标签
        $tabsFile = "tabs.json";
        $tabs = json_decode(file_get_contents($tabsFile), true);
        $tabIndex = array_search($tabName, $tabs);
        if ($tabIndex !== false) {
            unset($tabs[$tabIndex]);
            $jsonTabs = json_encode($tabs);
            file_put_contents($tabsFile, $jsonTabs);
            echo "Tab '$tabName' deleted from tabs list.";
        }
    } else {
        echo "Text file for tab '$tabName' does not exist.";
    }
}
?>
