<?php
header('Content-Type: text/plain; charset=utf-8');

$key = $_GET['key'] ?? '';
if ($key === '') {
    http_response_code(400);
    echo "Missing 'key' parameter";
    exit;
}

$dataFile = __DIR__ . '/data.json';
if (!file_exists($dataFile)) {
    http_response_code(404);
    echo "Not Found";
    exit;
}

$db = json_decode(file_get_contents($dataFile), true) ?: [];

if (!isset($db[$key])) {
    http_response_code(404);
    echo "Not Found";
    exit;
}

echo $db[$key];