<?php
header('Content-Type: text/plain; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $key = trim($_POST['key'] ?? '');
    $data = $_POST['data'] ?? '';
} else if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $key = trim($_GET['key'] ?? '');
    $data = $_GET['data'] ?? '';
} else {
    http_response_code(405);
    echo "Method Not Allowed";
    exit;
}

if ($key === '') {
    http_response_code(400);
    echo 'Missing "key" parameter';
    exit;
}

$dataFile = __DIR__ . '/data.json';
if (!file_exists($dataFile)) {
    file_put_contents($dataFile, '{}');
}
$db = json_decode(file_get_contents($dataFile), true) ?: [];

if ($data === '') {
    unset($db[$key]);
    echo "Deleted";
} else {
    $db[$key] = $data;
    echo "OK";
}

file_put_contents($dataFile, json_encode($db, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));